#
	#
	# global defaults
	#
	#
	
	font create title_font -size 20
	
	#
	#
	# Create a text widget with title displayed
	#
	#
	
	proc make_title {widget title_string} {
	text ${widget}.title -relief flat -foreground white -background black
	${widget}.title insert end ${title_string} title
	${widget}.title tag configure title -justify center -font title_font
	${widget}.title configure -height 2 -width 50
	}
	
	#
	#
	# Displays about box
	#
	#
	
	proc about_box {} {
	toplevel .about 
	frame .about.f -bd 4
	text   .about.f.text -relief flat -background black -foreground green
	.about.f.text insert end "Ps-i version 2.0 alpha" title
	.about.f.text insert end "\n\t\t\tpreliminary version" warning
	.about.f.text tag configure title -justify center -font title_font
	.about.f.text configure -width 50 -height 4
	button .about.f.ok -text "OK" -command { destroy .about }
	pack .about.f .about.f.text .about.f.ok
	update
	}
	
	
	#
	#
	# Asks user to choose attribute
	#
	#
	
	proc close_choose_attribute {choice_var} {
	global choose_attribute_var ${choice_var}
	set ${choice_var} $choose_attribute_var
	destroy .choose_attribute
	}
	
	proc new_choice_choose_attribute {} {
	global choose_attribute_var
	set i [find_attribute $choose_attribute_var]
	if {$i<0} {
		return;
		} else {
		.choose_attribute.f.comment delete 0.0 end
		.choose_attribute.f.comment insert end $i
		}
	}
	
	
	proc choose_attribute {choice_var} {
	global choose_attribute_var
	toplevel .choose_attribute
	frame .choose_attribute.f -bd 3
	pack .choose_attribute.f
	
	#
	# Title
	#
	
	make_title .choose_attribute.f "Choose attribute:"
	grid .choose_attribute.f.title - -sticky ew
	
	#
	# Main elements
	#
	combobox::combobox .choose_attribute.f.attr_list -height 7 -width 20 \
		-relief sunken -textvariable choose_attribute_var
	frame .choose_attribute.f.misc_info -bd 0
	grid .choose_attribute.f.attr_list .choose_attribute.f.misc_info -sticky news
	
	text .choose_attribute.f.comment -relief sunken 
	.choose_attribute.f.comment configure -width 50 -height 5
	grid .choose_attribute.f.comment - -sticky ew
	
	bind .choose_attribute.f.attr_list <<Combobox_change>> new_choice_choose_attribute
	
	#
	# control panel on the right
	#
	
	button .choose_attribute.f.misc_info.done -text "Apply" -command "close_choose_attribute ${choice_var}"
	grid .choose_attribute.f.misc_info.done
	
	set n [num_attributes]
	for {set i 0} {$i < $n} {incr i} {
		.choose_attribute.f.attr_list listinsert end [attribute_name $i]
		}
	}
	
	#
	#
	#   Asks user to choose a field
	#
	#
	
	
	proc close_choose_field {choice_var} {
	global choose_field_var ${choice_var}
	set ${choice_var} $choose_field_var
	destroy .choose_field
	}
	
	proc new_choice_choose_field {} {
	global choose_field_var
	set i [find_field $choose_field_var]
	if {$i<0} {
		return;
		} else {
		.choose_field.f.comment delete 0.0 end
		.choose_field.f.comment insert end $i
		}
	}
	
	
	proc choose_field {choice_var} {
	global choose_field_var
	toplevel .choose_field
	frame .choose_field.f -bd 3
	pack .choose_field.f
	
	#
	# Title
	#
	
	make_title .choose_field.f "Choose field:"
	grid .choose_field.f.title - -sticky ew
	
	#
	# Main elements
	#
	
	combobox::combobox .choose_field.f.attr_list -height 7 -width 20 \
		-relief sunken -textvariable choose_field_var
	frame .choose_field.f.misc_info -bd 0
	grid .choose_field.f.attr_list .choose_field.f.misc_info -sticky news
	
	text .choose_field.f.comment -relief sunken 
	.choose_field.f.comment configure -width 50 -height 5
	grid .choose_field.f.comment - -sticky ew
	
	bind .choose_field.f.attr_list <<Combobox_change>> new_choice_choose_field
	#
	# control panel on the right
	#
	button .choose_field.f.misc_info.done -text "Apply" -command "close_choose_field ${choice_var}"
	grid .choose_field.f.misc_info.done
	
	set n [num_fields]
	for {set i 0} {$i < $n} {incr i} {
		.choose_field.f.attr_list listinsert end [field_name $i]
		}
	}
	
	#
	#
	# new_field_viewer - opens a new field viewer window
	#
	#
	
	global fv_id
	global time
	global close_fv
	set fv_id 0
	
	proc new_field_viewer {} {
	global fv_id
	global time
	global close_fv 
	
	set w .field_viewer$fv_id
	
	toplevel $w
	set fv_id [expr $fv_id+1]
	
	trace variable time w "update_field_viewer $w"
	trace variable close_fv w "close_field_viewer $w"
	
	frame $w.panel
	pack $w.panel
	combobox::combobox $w.panel.view -width 15 -textvariable fv_cv$w
	combobox::combobox $w.panel.field -width 15 -textvariable fv_cf$w
	button $w.panel.step -text {Step} -command "step_model1"
	button $w.panel.runto -text {Run to..} -command "model_runto"
	label $w.panel.time -text "Time: [model_time]" -background black -foreground white
	grid $w.panel.view $w.panel.field $w.panel.step $w.panel.runto $w.panel.time 
	
	frame $w.f -bd 0
	pack $w.f -expand yes -fill both
	grid rowconfig $w 1 -weight 1
	grid columnconfig $w 0 -weight 1
	grid columnconfig $w 1 -weight 1
	grid columnconfig $w 2 -weight 1
	grid columnconfig $w 3 -weight 1
	canvas $w.f.display -xscrollcommand "$w.f.hscroll set" \
		-yscrollcommand "$w.f.vscroll set" -relief sunken -bd 2
	scrollbar $w.f.vscroll -command "$w.f.display yview"
	scrollbar $w.f.hscroll -command "$w.f.display xview" -orient horiz
	grid $w.f.display -sticky news;
	grid $w.f.vscroll -row 0 -column 1 -sticky ns
	grid $w.f.hscroll -row 1 -column 0 -sticky ew
	grid rowconfig $w.f 0 -weight 1
	grid columnconfig $w.f 0 -weight 1
	
	#
	# Put data inside
	#
	
	set n [num_fields]
	for {set i 0 } {$i <$n} {incr i} {
		$w.panel.field listinsert end [field_name $i]
		}
	if {$n >0 } {
		$w.panel.field insert end [field_name 0]
		}
		
	set n [num_views]
	for {set i 0 } {$i <$n} {incr i} {
		$w.panel.view listinsert end [view_name $i]
		}
	if {$n >0 } {
		$w.panel.view insert end [view_name 0]
		}
	bind $w.panel.view <<Combobox_change>> "update_field_viewer $w a b c"
	bind $w.panel.field <<Combobox_change>> "update_field_viewer $w a b c"
	update_field_viewer $w	a b c
	}
	
	proc update_field_viewer {w a b c} {
	global time
	
	#
	# get parameters
	#
	
	set field_name [$w.panel.field get]
	set view_name [$w.panel.view get]
	set field_index [find_field $field_name]
	set view_index [find_view $view_name]
	if { $field_index <0} {
		return;
		}
	if { $view_index <0} {
		return;
		}
	set x_size [field_x_dim $field_index]
	set y_size [field_y_dim $field_index]
	$w.f.display configure -scrollregion "-10 -10 [expr $x_size * 30+10] [expr $y_size *30+10]"
	$w.f.display delete [$w.f.display find all]
	for {set j 0} {$j < $y_size} {incr j} {
		for {set i 0} {$i < $x_size} {incr i} {
			set shape [view_shape $view_index $field_index $i $j]
			set color1 [view_color1 $view_index $field_index $i $j]
			set color2 [view_color2 $view_index $field_index $i $j]
			set color3 [view_color3 $view_index $field_index $i $j]
			if { $shape>=0 } {
				draw_agent $w.f.display [expr $i * 30] [expr $j * 30] \
					$shape $color1 $color2 $color3
				}
			}
		}
	$w.panel.time configure -text "Time: $time"
	}
	
	proc close_field_viewer {w a b c} {
	global time
	global close_fv
	trace vdelete time w "update_field_viewer $w"
	trace vdelete close_fv w "update_field_viewer $w"
	destroy $w
	}
	
	proc step_model1 {} {
	global time
	step_model
	set time [model_time]
	}
	
	#
	#
	# Stuff that draws agents
	#
	#
	
	#
	#  First: close up view
	#
	
	global agent_colors n_colors
	set agent_colors { magenta yellow red blue green brown }
	puts "++"
	set n_colors [llength $agent_colors]
	puts "++"
	
	proc get_color color {
	global agent_colors n_colors
	set c [expr $color % $n_colors]
	return [lindex $agent_colors $c]
	}
	
	proc draw_agent_square {canv x y color1 color2} {
	set x1 [expr $x]
	set y1 [expr $y]
	set x2 [expr $x+30]
	set y2 [expr $y+30]
	$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color1] -outline black
	set x1 [expr $x+10]
	set y1 [expr $y+10]
	set x2 [expr $x+20]
	set y2 [expr $y+20]
	$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
	}
	
	proc draw_agent_pentagon {canv x y color1 color2} {
	set x1 [expr $x+15]
	set y1 [expr $y]
	set x2 [expr $x+30]
	set y2 [expr $y+10]
	set x3 [expr $x+25]
	set y3 [expr $y+30]
	set x4 [expr $x+5]
	set y4 [expr $y+30]
	set x5 [expr $x]
	set y5 [expr $y+10]
	$canv create polygon $x1 $y1 $x2 $y2 $x3 $y3 $x4 $y4 $x5 $y5 -fill [get_color $color1] -outline black
	set x1 [expr $x+10]
	set y1 [expr $y+12]
	set x2 [expr $x+20]
	set y2 [expr $y+22]
	$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
	}
	
	proc draw_agent_oval {canv x y color1 color2} {
	set x1 [expr $x]
	set y1 [expr $y]
	set x2 [expr $x+30]
	set y2 [expr $y+30]
	$canv create oval $x1 $y1 $x2 $y2  -fill [get_color $color1] -outline black
	set x1 [expr $x+10]
	set y1 [expr $y+10]
	set x2 [expr $x+20]
	set y2 [expr $y+20]
	$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
	}
	
	proc draw_agent_black {canv x y color1 color2} {
	set x1 [expr $x]
	set y1 [expr $y]
	set x2 [expr $x+30]
	set y2 [expr $y+30]
	$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill gray -outline black
	}
	
	proc draw_agent {canv x y shape color1 color2 color3} {
	switch $shape \
		0 "draw_agent_square $canv $x $y $color1 $color2" \
		1 "draw_agent_pentagon $canv $x $y $color1 $color2" \
		2 "draw_agent_oval $canv $x $y $color1 $color2" \
		10 "draw_agent_black $canv $x $y $color1 $color2"
	}
	
	
	#
	# Submit model - loads the contents of the buffer into the engine
	#
	#
	
	proc submit_model {} {
	global close_fv
	global time
	set buffer [.f.model get 0.0 end ]
	
	#
	# close old file viewer windows
	#
	
	set close_fv 1
	
	#
	# reset model
	#
	
	reset_model
	set time 0
	
	#
	# load code
	#
	
	set success [yyparse_string $buffer]
	
	#
	# Check whether we got an error
	#
	
	if { $success < 0 } {
		set line [get_line_of_error]
		set char [get_char_of_error]
		.f.model see ${line}.${char}
		.f.model tag add sel ${line}.0 ${line}.${char}
		set message [get_message_of_error]
		show_status_error $message
		return
		}
	show_status_success "Data accepted with no problems."
	seed_fields
	}
	
	#
	#
	# Runto - batch processing
	#
	#
	
	proc model_runto {} {
	global time
	toplevel .runto
	label .runto.l0 -text "Step until:"
	entry .runto.value 
	.runto.value insert end "$time"
	button .runto.go -text "Go!" -command model_runto_go
	grid .runto.l0 .runto.value -sticky news
	grid .runto.go - -sticky news
	grab set .runto
	}
	
	proc model_runto_go {} {
	global time
	
	set dest_time [.runto.value get]
	grab release .runto
	destroy .runto
	
	if {$dest_time <= $time} {
		return
		}
	toplevel .runto_progress
	grab set .runto_progress
	label .runto_progress.l0 -text "Computation in progress..."
	scale .runto_progress.scale -orient horiz -from $time -to $dest_time
	pack .runto_progress.l0
	pack .runto_progress.scale
	for {set i $time} {$i < $dest_time} {incr i} {
		step_model
		.runto_progress.scale set $i
		update
		}
	.runto_progress.l0 configure -text "Updating windows..."
	update
	set time [model_time]
	grab release .runto_progress
	destroy .runto_progress
	}
	
	#
	#
	# Model input-output
	#
	#
	
	global fn
	set fn "test1.mdl"
	
	proc save_model1 {} {
	global fn
	set fn [tk_getSaveFile -defaultextension {.mdl} -initialfile $fn ]
	set fileid [open $fn w]
	set model_data [.f.model get 0.0 end]
	puts $fileid $model_data
	close $fileid
	}
	
	proc load_model1 {} {
	global fn 
	set fn [tk_getOpenFile -defaultextension {.mdl} \
		-filetypes { {"Ps-i model" { .mdl } } {"All files" { .* } } }]
	if {[winfo exists .ac_editor]} {
		destroy .ac_editor
		}
	if {[ catch {	set fileid [open $fn r]	} ]<0 } {
		show_status_error "Open failed";
		return; 
		}
	
	set model_data [read $fileid]
	close $fileid
	.f.model delete 0.0 end
	.f.model insert end $model_data
	set status "Successfully loaded "
	append status $fn
	show_status_normal $status
	}
	
	#
	#
	# This controls the nice status line in the bottom
	#
	#
	
	proc show_status_normal a {
	.f.status insert end "\n"
	.f.status insert end $a normal
	.f.status tag configure normal -foreground yellow
	.f.status see end
	}
	
	proc show_status_success a {
	.f.status insert end "\n"
	.f.status insert end $a success
	.f.status tag configure success -foreground green
	.f.status see end
	}
	
	proc show_status_error a {
	.f.status insert end "\n"
	.f.status insert end $a error
	.f.status tag configure error -foreground red
	.f.status see end
	}
	
	
	#
	#
	#  Main window routines
	#
	#
	
	frame .f -bd 0
	pack .f -expand yes -fill both
	
	#
	# Menu
	#
	
	menu .menu
	menu .menu.file -tearoff false
	menu .menu.help -tearoff false
	menu .menu.options -tearoff false
	menu .menu.options.wrap -tearoff false
	. configure -menu .menu
	
	.menu add cascade -label {File} -menu .menu.file
	.menu add cascade -label {Options} -menu .menu.options
	.menu add cascade -label {Help} -menu .menu.help
	
	
	.menu.help add command -label {About} -command about_box
	
	.menu.file add command -label {Load model} -command load_model1
	.menu.file add command -label {Save model} -command save_model1
	.menu.file add separator
	.menu.file add command -label {Exit} -command exit
	
	.menu.options add cascade -label {Wrap} -menu .menu.options.wrap
	.menu.options.wrap add radiobutton -label {None} -command {.f.model configure -wrap none}
	.menu.options.wrap add radiobutton -label {Character} -command {.f.model configure -wrap char}
	.menu.options.wrap add radiobutton -label {Word} -command {.f.model configure -wrap word}
	
	text .f.model -relief sunken -wrap none -xscrollcommand ".f.hscroll set" \
		-yscrollcommand ".f.vscroll set" -takefocus 1
	.f.model configure -width 80 -height 30
	
	scrollbar .f.vscroll -command ".f.model yview"
	scrollbar .f.hscroll -command ".f.model xview" -orient horiz
	scrollbar .f.vscroll1 -command ".f.status yview" 
	
	grid .f.model  -sticky news
	grid .f.vscroll -row 0 -column 1 -sticky ns
	grid .f.hscroll  -row 1 -column 0 -sticky ew
	grid rowconfig .f 0 -weight 1
	grid columnconfig .f 0 -weight 1
	text .f.status -relief flat -background black -yscrollcommand ".f.vscroll1 set"
	
	.f.status configure -width 80 -height 3 -takefocus 0
	grid .f.status -row 2 -column 0 -sticky ew
	grid .f.vscroll1 -row 2 -column 1 -sticky ns
	
	button .submit -text "Submit" -command "submit_model" -activebackground red
	button .new_fv -text "New field viewer" -command "new_field_viewer" -activebackground yellow
	button .test -text "Test" -command "choose_field test_var"
	
	
	pack .submit .new_fv .test -side left
	
	#
	#
	# Initial sequence of commands
	#
	#
	
	update
	load_model1
